%%
%%  File: imuwbth.cls
%%
%%  Author: Mariusz \.Zynel
%% 
%%  Description: LaTeX document class for specific thesis layout for IM UwB.
%%
%%  Create date: Nov 7, 2001
%%
%%  Last modified: Jun 29, 2021
%%
%%
%%  Copyright (c) 2001-2019 Mariusz Zynel <mariusz@math.uwb.edu.pl>.
%%
%%  This  software  is  FREE.  You can use  and/or  redistribute  it for any
%%  purpose in either,  modified, or unmodified form, under the terms of the
%%  GNU General Public License as published by the Free Software Foundation.
%%
%%  The above copyright notice and this permission  notice shall be included
%%  in all copies or substantial portions of this software.
%%
%%  THIS  SOFTWARE IS PROVIDED AS IS AND COME WITH NO WARRANTY  OF ANY KIND,
%%  EITHER  EXPRESSED OR IMPLIED.  IN NO EVENT WILL THE COPYRIGHT  HOLDER BE
%%  LIABLE FOR ANY DAMAGES RESULTING FROM THE USE OF THIS SOFTWARE.
%%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{imuwbth}[2019/06/29 v2.8 LaTeX document class (MZ)]

\newif\if@marginnotes       \@marginnotesfalse
\newif\if@hyperref          \@hyperreffalse

\let\@mkboth\markboth
\let\@mkright\markright
\let\@xunderrule\relax
\let\@xoverrule\relax

\newif\if@showproofs
\newif\if@showmarginals     \@showmarginalstrue
\newif\if@final             \@finalfalse

\newif\if@thankstop

\DeclareOption{dyplom}{\def\@thesiskind{dyplomowa}}
\DeclareOption{dyplomowa}{\def\@thesiskind{dyplomowa}}
\DeclareOption{magisterium}{\def\@thesiskind{magisterska}}
\DeclareOption{magisterska}{\def\@thesiskind{magisterska}}

\DeclareOption{marginnotes}{\@marginnotestrue}
\DeclareOption{hyperref}{\@hyperreftrue}
\DeclareOption{upcasehead}{%
  \def\@mkboth#1#2{\markboth{\MakeUppercase{#1}}{\MakeUppercase{#2}}}
  \def\@mkright#1{\markright{\MakeUppercase{#1}}}}
\DeclareOption{underruledhead}{\def\@xunderrule{\@underrule}}
\DeclareOption{overruledfoot}{\def\@xoverrule{\@overrule}}

\DeclareOption{showproofs}{\@showproofstrue}
\DeclareOption{hideproofs}{\@showproofsfalse}
\DeclareOption{showmarginals}{\@showmarginalstrue\@marginnotestrue}
\DeclareOption{hidemarginals}{\@showmarginalsfalse}
\DeclareOption{abstract}{%
  \@showproofsfalse
  \@showmarginalsfalse}
\DeclareOption{final}{%
  \@showproofstrue
  \@showmarginalsfalse
  \@finaltrue}
\DeclareOption{aleft}{%
  \def\@ragged{\raggedright}
  \def\@alignment{l}}
\DeclareOption{aright}{%
  \def\@ragged{\raggedleft}
  \def\@alignment{r}}

\DeclareOption{thankstop}{\@thankstoptrue}
\DeclareOption{thanksbottom}{\@thankstopfalse}

\DeclareOption{iso}{%
     \typeout{\space\space\space Selected input encoding `iso8859-2'.}
     \PassOptionsToPackage{latin2}{inputenc}}
\DeclareOption{iso8859-2}{%
     \typeout{\space\space\space Selected input encoding `iso8859-2'.}
     \PassOptionsToPackage{latin2}{inputenc}}
\DeclareOption{dos}{%
     \typeout{\space\space\space Selected input encoding `DOS 852CP'.}
     \PassOptionsToPackage{cp852}{inputenc}}     
\DeclareOption{cp1250}{%
     \typeout{\space\space\space Selected input encoding `DOS 852CP'.}
     \PassOptionsToPackage{cp1250}{inputenc}}     
\DeclareOption{windows}{%
     \typeout{\space\space\space Selected input encoding `DOS 852CP'.}
     \PassOptionsToPackage{cp1250}{inputenc}}
\DeclareOption{utf8}{%
     \typeout{\space\space\space Selected input encoding `UTF-8'.}
     \PassOptionsToPackage{utf8}{inputenc}}     
\DeclareOption{maz}{%
     \typeout{\space\space\space Selected input encoding `Mazovia'.}
     \PassOptionsToPackage{mazovia}{polski}}
\DeclareOption{mazovia}{%
     \typeout{\space\space\space Selected input encoding `Mazovia'.}
     \PassOptionsToPackage{mazovia}{polski}}
\DeclareOption{mazowia}{%
     \typeout{\space\space\space Selected input encoding `Mazovia'.}
     \PassOptionsToPackage{mazovia}{polski}}
  
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}

\ExecuteOptions{underruledhead,showproofs,showmarginals,aleft,thanksbottom,iso,magisterska}
\ProcessOptions\relax
\LoadClass[a4paper,12pt,oneside]{book}

\RequirePackage{polski}[1998/04/20 v1.3.1]
\RequirePackage{inputenc}[1999/09/17 v1.0d]

%%%% monogrph.cls

\setlength\headsep   {25\p@}
\if@compatibility
\else
  \setlength\@tempdima{\paperwidth}
  \addtolength\@tempdima{-2in}
  \setlength\@tempdimb{396\p@}
  \if@twocolumn
    \ifdim\@tempdima>2\@tempdimb\relax
      \setlength\textwidth{2\@tempdimb}
    \else
      \setlength\textwidth{\@tempdima}
    \fi
  \else
    \ifdim\@tempdima>\@tempdimb\relax
      \setlength\textwidth{\@tempdimb}
    \else
      \setlength\textwidth{\@tempdima}
    \fi
  \fi
  \@settopoint\textwidth

  \setlength\@tempdima{\paperheight}
  \addtolength\@tempdima{-2in}
  \addtolength\@tempdima{-\headheight}
  \addtolength\@tempdima{-\headsep}
  \addtolength\@tempdima{-\footskip}
  \divide\@tempdima\baselineskip
  \@tempcnta=\@tempdima
  \setlength\textheight{\@tempcnta\baselineskip}
  \addtolength\textheight{\topskip}

  \if@marginnotes  %Exchanged with \if@twoside for better layout control.
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.4\@tempdima}
    \addtolength\oddsidemargin  {-1in}
    \setlength\marginparwidth   {.6\@tempdima}
    \addtolength\marginparwidth {-\marginparsep}
    \addtolength\marginparwidth {-0.4in}
  \else
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.5\@tempdima}
    \addtolength\oddsidemargin  {-1in}
    \setlength\marginparwidth   {.5\@tempdima}
    \addtolength\marginparwidth {-\marginparsep}
    \addtolength\marginparwidth {-0.4in}
    \addtolength\marginparwidth {-.4in}
  \fi
  \ifdim \marginparwidth >2in
     \setlength\marginparwidth{2in}
  \fi
  \@settopoint\oddsidemargin
  \@settopoint\marginparwidth
  \setlength\evensidemargin  {\paperwidth}
  \addtolength\evensidemargin{-2in}
  \addtolength\evensidemargin{-\textwidth}
  \addtolength\evensidemargin{-\oddsidemargin}
  \@settopoint\evensidemargin

  \setlength\topmargin{\paperheight}
  \addtolength\topmargin{-2in}
  \addtolength\topmargin{-\headheight}
  \addtolength\topmargin{-\headsep}
  \addtolength\topmargin{-\textheight}
  \addtolength\topmargin{-\footskip}     % this might be wrong!
  \addtolength\topmargin{-.5\topmargin}
  \@settopoint\topmargin
\fi

\DeclareFontShape{OT1}{cmr}{bx}{sc}
      {
      <5><6><7>cmbxsc7%
      <8>cmbxsc8%
      <9>cmbxsc9%
      <10><10.95>cmbxsc10%
      <12><14.4><17.28><20.74><24.88>cmbxsc12%
      }{}

\def\title{\@dblarg\@xtitle}
\def\@xtitle[#1]#2{\gdef\@title{#2}\gdef\@brieftitle{#1}}
\let\@brieftitle\@empty

\def\stroke#1#2{%
  \setbox\@tempboxa=\hbox{#2}%
  \rule[#1]{\wd\@tempboxa}{0.4pt}\llap{\usebox\@tempboxa}}
\def\@underrule#1{%
  \stroke{-1.3ex}{\hbox to\textwidth{#1}}}
\def\@overrule#1{%
  \stroke{2.6ex}{\hbox to\textwidth{#1}}}

\def\cleardoublepage{\clearpage\if@twoside \ifodd\c@page\else
    \markboth{}{}\hbox{}\newpage\if@twocolumn\hbox{}\newpage\fi\fi\fi}

\def\oddfoot{\reset@font\hfil\thepage\hfil}
\let\evenfoot\oddfoot
\def\oddhead{{\scshape\rightmark}\hfil\thepage}%
\def\evenhead{\thepage\hfil\scshape\leftmark}%
\let\chapapp\@chapapp
\def\chaptermarker{\chapapp\ \thechapter. \ }
\def\chaptertitle#1{#1}
\def\sectionmarker{\thesection. \ }
\def\sectiontitle#1{#1}

\def\ps@plain{\let\@mkboth\@gobbletwo
     \let\@oddhead\@empty
     \def\@oddfoot{\@xoverrule\oddfoot}
     \let\@evenhead\@empty
     \def\@evenfoot{\@xoverrule\evenfoot}}

\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty
      \let\@evenfoot\@empty
      \def\@evenhead{\@xunderrule\evenhead}
      \def\@oddhead{\@xunderrule\oddhead}
      \def\chaptermark##1{%
        \@mkboth {%
          \ifnum \c@secnumdepth >\m@ne
            \chaptermarker
          \fi
          \chaptertitle{##1}}{}}%
      \def\sectionmark##1{%
        \@mkright {%
          \ifnum \c@secnumdepth >\z@
            \if@mainmatter
              \sectionmarker
            \fi
          \fi
          \sectiontitle{##1}}}}
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{\@xunderrule\oddhead}
    \def\chaptermark##1{%
     \@mkright {%
       \ifnum \c@secnumdepth >\m@ne
         \chaptermarker
       \fi
       \chaptertitle{##1}}}}
\fi

\def\ps@simplehead{%
  \let\chaptertitle\@gobble
  \def\chaptermarker{\@chapapp\ \thechapter}
  \ps@headings}

\def\ps@centeredhead{%
  \let\chaptermarker\@empty
  \let\sectionmarker\@empty
  \def\oddhead{\hfil{\scshape\rightmark}\hfil\thepage}%
  \def\evenhead{\thepage\hfil{\scshape\leftmark}\hfil}%
  \ps@headings}

\def\ps@rawheadandfoot{%
  \ps@headings
  \def\@oddfoot{\@xoverrule\oddfoot}
  \def\@evenfoot{\@xoverrule\evenfoot}}

\def\ps@headandfoot{%
  \def\oddfoot{\reset@font\hfil\thepage}
  \def\evenfoot{\reset@font\thepage\hfil}
  \def\oddhead{\hfil{\scshape\rightmark}}%
  \def\evenhead{\scshape\leftmark\hfil}%
  \ps@rawheadandfoot}

\def\ps@simpleheadandfoot{%
  \let\chaptertitle\@gobble
  \def\chaptermarker{\@chapapp\ \thechapter}
  \ps@headandfoot}

\def\ps@centeredheadandfoot{%
  \let\chaptermarker\@empty
  \let\sectionmarker\@empty
  \def\oddhead{\hfil{\scshape\rightmark}\hfil}%
  \def\evenhead{\hfil{\scshape\leftmark}\hfil}%
  \def\oddfoot{\reset@font\hfil\thepage\hfil}
  \let\evenfoot\oddfoot
  \ps@rawheadandfoot}

\def\@chapter[#1]#2{\ifnum \c@secnumdepth >\m@ne
                       \if@mainmatter
                         \refstepcounter{chapter}%
                         \typeout{\@chapapp\space\thechapter.}%
                         \addcontentsline{toc}{chapter}%
                                   {\protect\numberline{\thechapter}#2}%
                       \else
                         \typeout{#1}%
                         \addcontentsline{toc}{chapter}{#2}%
                       \fi
                    \else
                      \addcontentsline{toc}{chapter}{#2}%
                    \fi
                    \if@mainmatter
                      \chaptermark{#1}%
                      \addtocontents{lof}{\protect\addvspace{10\p@}}%
                      \addtocontents{lot}{\protect\addvspace{10\p@}}%
                      \if@twocolumn
                        \@topnewpage[\@makechapterhead{#2}]%
                      \else
                        \@makechapterhead{#2}%
                        \@afterheading
                      \fi
                    \else
                      \@pchapter{#2}
                    \fi}
\def\@schapter#1{%
        \if@mainmatter
                \typeout{#1}%
                \addcontentsline{toc}{chapter}{#1}%
        \fi
        \@pchapter{#1}}
\def\@pchapter#1{%
	\@mkboth{#1}{#1}
	\if@twocolumn
        	\@topnewpage[\@makeschapterhead{#1}]%
	\else
		\@makeschapterhead{#1}%
		\@afterheading
	\fi}
		 
\renewcommand\appendix{\par
  \setcounter{chapter}{0}%
  \setcounter{section}{0}%
  \renewcommand\@chapapp{\appendixname}%
  \let\chapapp\@chapapp
  \renewcommand\thechapter{\@Alph\c@chapter}}
\renewcommand\tableofcontents{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter*{\contentsname}%
    \@starttoc{toc}%
    \if@restonecol\twocolumn\fi
    }
\renewcommand\listoffigures{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter{\listfigurename}%
    \@starttoc{lof}%
    \if@restonecol\twocolumn\fi
    }
\renewcommand\listoftables{%
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse
    \fi
    \chapter{\listtablename}%
    \@starttoc{lot}%
    \if@restonecol\twocolumn\fi
    }
\let\biblabel\@biblabel    
\renewenvironment{thebibliography}[1]{%
    \chapter{\bibname}
    \list{\biblabel{\@arabic\c@enumiv}}%
	 {\settowidth\labelwidth{\biblabel{#1}}%
	  \leftmargin\labelwidth
	  \advance\leftmargin\labelsep
	  \@openbib@code
	  \usecounter{enumiv}%
	  \let\p@enumiv\@empty
	  \renewcommand\theenumiv{\@arabic\c@enumiv}}%
    \sloppy\clubpenalty4000\widowpenalty4000%
    \sfcode`\.\@m%
  }{%
    \def\@noitemerr{\@latex@warning{Empty `thebibliography' environment}}%
    \endlist}
\renewenvironment{theindex}{%
    \if@twocolumn
      \@restonecolfalse
    \else
      \@restonecoltrue
    \fi
    \columnseprule \z@
    \columnsep 35\p@
    \twocolumn[\@makeschapterhead{\indexname}]%
    \typeout{\indexname}
    \addcontentsline{toc}{chapter}{\indexname}%
    \@mkboth{\indexname}{\indexname}%
    \thispagestyle{plain}\parindent\z@
    \parskip\z@ \@plus .3\p@\relax
    \let\item\@idxitem%
  }{%
    \if@restonecol\onecolumn\else\clearpage\fi}
\newcommand{\marginnotes}[1]{%
  \hskip 1sp \marginpar{\small\raggedright #1}}

%%%% end of monogrph.cls


%%%% datetime.sty

\newcount\count@a
\newcount\count@b

\count@a\time
\divide\count@a 60
\count@b=-\count@a
\multiply\count@b 60
\advance\count@b \time
\edef\curhour{\number\count@a}
\edef\curminute{\number\count@b}
\edef\curHour{\two@digits{\curhour}}
\edef\curMinute{\two@digits{\curminute}}

\edef\curtime{\curHour:\curMinute}

\edef\curday{\number\day}
\edef\curDay{\two@digits{\curday}}

\edef\curmonth{\number\month}
\edef\curMonth{\two@digits{\curmonth}}

\edef\curmonthname{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi}
\def\curmonthsname{\expandafter\first@three\curmonthname\@stop}

\edef\curyear{\number\year}
\def\curyears{\expandafter\last@two\curyear\@stop}

\def\curdate{\curyear.\curMonth.\curDay}
\def\curdatetime{\curdate\space\curtime}

\def\now{\curmonthsname\space\curday\space\curtime\space\curyear}

\def\first@three#1#2#3#4\@stop{#1#2#3}
\def\last@two#1#2#3#4{#3#4}
\def\@stop{\relax}

%%%% end of datetime.sty


%%%% wsheet.cls

%% Standard class error handlers
\newcommand{\wsheet@err}{\ClassError{WSheet}}
\newcommand{\wsheet@warn}{\ClassWarning{WSheet}}

%% Footer information declaration
\def\created#1{\gdef\@created{#1}}
\let\@created\@empty
\def\modified#1{\gdef\@modified{#1}}
\gdef\@modified{\curdate}
\gdef\@typeset{\curdatetime}

\def\@statusbar{\hbox to\textwidth{%
  \reset@font\ttfamily\fontsize{9pt}{10pt}\selectfont%
  File\@colon\jobname\hfil%
  Created\@colon\@created\hfil%
  Modified\@colon\@modified\hfil%
  Typeset\@colon\@typeset}}

\def\supportauthor#1{%
  \ifx\@supportauthor\@empty
  \else
    \redef@warn{supportauthor}
  \fi
  \gdef\@supportauthor{#1}}
\let\@supportauthor\@empty

\def\@authorbar{%
  \ifx\@supportauthor\@empty
  \else
    \parbox{\textwidth}{%
      \reset@font\ttfamily\tiny%
      Work sheet prepared with kind support of \@supportauthor.\hss}
  \fi}

\def\info#1{\gdef\@info{#1}}
\let\@info\@empty
\def\@infobar{\parbox{\textwidth}{%
  \reset@font\ttfamily\tiny%
  \@info\hss}}
\def\@colon{:\kern3\p@}

%% Page style definitions
%% Style (default): headandfoot
\def\ps@headandfoot{%
  \if@final
    \def\oddfoot{%
      \ifnum\c@page=\@ne%
        \leavevmode%
        \hfil\thepage\hfil
      \else  
        \let\oddfoot\relax
      \fi}
    \def\oddhead{\hbox to\textwidth{%
      \reset@font\scshape\@brieftitle\hfil\thepage}}
  \else
    \def\oddfoot{%
      \ifnum\c@page=\@ne%
        \leavevmode%
        \vtop{\baselineskip\z@skip \lineskip1.5ex%
          \@statusbar
          \@authorbar \lineskip1ex%
	  \@infobar}%
      \else
        \@statusbar%
      \fi}
    \def\oddhead{\hbox to\textwidth{%
      \reset@font\ttfamily\footnotesize\@brieftitle\hfil\thepage}}
    \fi
  \let\evenfoot\oddfoot
  \let\evenhead\oddhead
  \ps@rawheadandfoot}

%% Page layout settings
\if@marginnotes
  \setlength\marginparsep     {.8\marginparsep}
  \setlength\@tempdima        {\paperwidth}
  \addtolength\@tempdima      {-\textwidth}
  \setlength\marginparwidth   {.34\@tempdima}
  \setlength\oddsidemargin    {\marginparwidth}
  \addtolength\oddsidemargin  {\marginparsep}
  \addtolength\oddsidemargin  {16\p@}
  \addtolength\oddsidemargin  {-1in}
  \reversemarginpar
\fi
\if@showmarginals
  \ifdim \marginparwidth <.5in
     \wsheet@warn{\protect\marginparwidth\space too little to put labels}
  \fi   
\fi
\ifdim \marginparwidth >2in
   \setlength\marginparwidth{2in}
\fi
\@settopoint\oddsidemargin
\@settopoint\marginparwidth
\setlength\evensidemargin  {\paperwidth}
\addtolength\evensidemargin{-2in}
\addtolength\evensidemargin{-\textwidth}
\addtolength\evensidemargin{-\oddsidemargin}
\@settopoint\evensidemargin

%% Writing to margin
\renewcommand\marginnotes[1]{%
  \ifinner
    \wsheet@warn{Inner mode, suppressing marginal notes}
  \else
    \hskip 1sp \marginpar{\normalfont\ttfamily\tiny\@ragged\ignorespaces #1}
  \fi}

\newcommand\marginbox[2][\@alignment]{%
  \hbox to\marginparwidth{%
    \expandafter\expandafter\expandafter\ifx #1l\relax
      #2\hss%
    \else
      \hss#2%
    \fi}}

\newcommand\putonmargin[2][\alignment]{%
  \marginnotes{%
    \marginbox[#1]{#2}}}

%% Main
\let\label@org\label
\def\showlabel#1{%
    \marginnotes{%
      \marginbox{[\ref{#1}]}
      \marginbox{#1}}}
\def\label@new#1{%
  \label@org{#1}%
  \if@showmarginals
    \showlabel{#1}%
  \fi}

\let\bibitem@org\bibitem
\def\bibitem@new#1{%
  \bibitem@org{#1}%
  \if@showmarginals%
    \marginnotes{%
      \marginbox{[#1]}}
  \fi}
\let\bibitem\bibitem@new  

\def\showmarginals{\@showmarginalstrue}
\def\hidemarginals{\@showmarginalsfalse}

\let\proof@org\proof
\let\endproof@org\endproof
\def\showproofs{\global\let\proof\proof@org\global\let\endproof\endproof@org}
\def\hideproofs{\gdef\proof{\@commentout}\global\let\endproof\relax}
\if@showproofs%
  \showproofs
\fi

\def\warningname{Warning!}
\newcounter{warning}
\newcommand\warningmark{\ensuremath{\bigstar^{\thewarning}}}
\def\avoidmark{%
  \ensuremath{[\ldots\mkern-.2mu]%
  \if@showmarginals
    ^{\thewarning}
  \fi}}
\newcommand\warningmarginlabel{\warningname\space[\thewarning]}

\newcommand{\warning}[1][]{%
  \if@showmarginals
    \stepcounter{warning}%
    \warningmark
    \marginnotes{%
      \marginbox{\warningmarginlabel}
      #1}
  \fi}
\let\problem\warning

\newenvironment{hypothesis}{%
  \if@showmarginals
    \stepcounter{warning}%
    \warningmark
    \marginnotes{%
      \marginbox{\warningmarginlabel}
      Czy to prawda?}
  \fi
}{%
  \if@showmarginals
    \ignorespaces
    $\blacksquare$\space
  \fi}

\def\why{{\Large\bfseries ???}}

%% Commenting environment
\def\@makeinnocent#1{\catcode`#1=12 }

\begingroup
  \@makeinnocent\^^M%
  \endlinechar=-1%
  \gdef\@startcommentout#1^^M{%
    \expandafter\@commentoutline}
  \gdef\@commentoutline#1^^M{%
    \def\@tmpline{#1}%
    \ifx\@commentstopmark\@tmpline
      \edef\@next{\endgroup\noexpand\end{\@currenvir}}%
    \else
      \let\@next\@commentoutline
    \fi %
    \@next}
\endgroup

\def\@commentout{%
  \begingroup
    \escapechar=-1\relax
    \xdef\@commentstopmark{\string\\end\string\{\@currenvir\string\}}
  \endgroup
  \begingroup
  \let\do\@makeinnocent \dospecials
  \@makeinnocent\^^L%
  \endlinechar`\^^M \catcode`\^^M=12 \@startcommentout}

\newenvironment{commentout}{%
  \@commentout
}{}

\newenvironment{avoid}{%
  \if@showmarginals
    \stepcounter{warning}%
    \marginnotes{%
      \marginbox{\warningmarginlabel}
      Text avoided}
  \fi
  \avoidmark
  \@commentout
}{}

\if@final\else
  %% References format
  \let\thebibliography@org\thebibliography
  \def\thebibliography{\footnotesize\thebibliography@org}

  %% Index format
  \let\theindex@org\theindex
  \def\theindex{\footnotesize\theindex@org}
\fi

%% Specific class error handlers
\def\redef@warn#1{\wsheet@warn{%
    \protect#1\space is already defined.}}

%%%% end of wsheet.cls


%%%% masterth.sty

\newcommand{\@masterth@err}{\PackageError{MasterTh}}

\def\university#1{\gdef\@university{#1}}
\def\faculty#1{\gdef\@faculty{#1}}
\def\institute#1{\gdef\@institute{#1}}
\def\author#1{\gdef\@author{#1}}
\def\title#1{\gdef\@title{#1}}
\def\placeandyear#1{\gdef\@placeandyear{#1}}
\def\supervisor#1{\gdef\@supervisor{#1}}

\newcommand\undersupervision{%
  \slshape Praca zosta\PLSlash la napisana\\
  \slshape pod kierunkiem\\
  \upshape \@supervisor}%
\newcommand\thanksname{Podzi\PLSlash ekowania}

\def\@undef@err#1{\@masterth@err{%
    Undefined \protect#1.
  }{%
    Terminate and complete description of the title page.
  }}%

\def\@university{\@undef@err{\university}}
\let\@division\@empty
\def\@institute{\@undef@err{\institute}}
\def\@author{\@undef@err{\author}}
\def\@title{\@undef@err{\title}}
\def\@placeandyear{\@undef@err{\placeandyear}}
\let\@supervisor\@empty

\renewenvironment{titlepage}{%
    \cleardoublepage
    \if@twocolumn
      \@restonecoltrue\onecolumn
    \else
      \@restonecolfalse\newpage
    \fi
    \thispagestyle{empty}%
  }%
  {\if@restonecol\twocolumn \else \newpage \fi}

\renewcommand\maketitle{%
  \begin{titlepage}
    \begin{center}
      {\Huge\scshape\@university \par}
      \vskip 20\p@
      {\LARGE\scshape\@faculty \par}
      \vskip 20\p@
      {\Large\scshape\@institute \par}
      %\vskip 120\p@
      \vfil\vfil\vfil\vfil
      {\large\@author}
      %\vskip 54\p@
      \vfil
      {\Huge\scshape%
         \def\arraystretch{1.2}
         \begin{center}
            \@title
         \end{center}%
         \def\arraystretch{1}}
    \end{center}\par
    \vfil\vfil\vfil
    \vbox{\hfill
      \begin{tabular}{l}
        \undersupervision
      \end{tabular}\par}
    %\vskip 1in
    \vfil\vfil
    \begin{center}
      \Large\@placeandyear \par
    \end{center}
  \end{titlepage}
  \if@twoside\else\setcounter{page}\@ne\fi}

\if@thankstop
  \renewenvironment{thanks}{%
      \begin{titlepage}
      \thispagestyle{empty}%
      \null\vskip 50\p@
      \begin{center}
        \Large\scshape
        \MakeUppercase{\thanksname} \par
      \end{center}
      \vskip 40\p@
      \@afterindentfalse
    }%
    {\null\vskip 26\p@
     \hfill\@author
     \end{titlepage}}
\else
  \renewenvironment{thanks}{%
      \begin{titlepage}
      \thispagestyle{empty}%
      \null\vfill
      \hfill
      \begin{tabular}{l}
    }%
    {\end{tabular}\par
      \vskip 16\p@
      \hfill\@author\par
      \rule{0pt}{48pt}
      \end{titlepage}}
\fi

%%%% end of masterth.sty


%%%% math.sty

\RequirePackage{latexsym}[1995/12/01 v2.2e]
\RequirePackage{amsmath}[1997/03/20 v1.2d]
\RequirePackage{amsthm}[1996/10/24 v1.2d]
\RequirePackage{amssymb}[1996/11/03 v2.2b]
\RequirePackage{amsfonts}[1997/09/17 v2.2e]

\DeclareFontShape{OT1}{cmr}{bx}{sc}
      {
      <5><6><7>cmbxsc7%
      <8>cmbxsc8%
      <9>cmbxsc9%
      <10><10.95>cmbxsc10%
      <12><14.4><17.28><20.74><24.88>cmbxsc12%
      }{}

\let\theequation@org\theequation
\newenvironment{displaystatement}[1][]{%
  \def\theequation{#1}
  \equation
}{%
  \endequation
  \let\theequation\theequation@org}

\AtBeginDocument{%
  \newcommand\theoremname{Twierdzenie}
  \newcommand\lemmaname{Lemat}
  \newcommand\corollaryname{Wniosek}
  \newcommand\propositionname{Stwierdzenie}
  \newcommand\conjecturename{Przypuszczenie}
  \newcommand\criterionname{Kryterium}
  \newcommand\algorithmname{Algorytm}
  \newcommand\factname{Fakt}
  \newcommand\hypothesisname{Hipoteza}
  \newcommand\definitionname{Definicja}
  \newcommand\conditionname{Warunek}
  \newcommand\problemname{Problem}
  \newcommand\examplename{Przyk\PLSlash lad}
  \newcommand\exercisename{Zadanie}
  \newcommand\remarkname{Uwaga}
  \newcommand\notename{Adnotacja}
  \newcommand\notationname{Notacja}
  \newcommand\claimname{Stwierdzenie}
  \newcommand\summaryname{Streszczenie}
  \newcommand\acknowledgmentname{Podzi\PLSlash ekowania}
  \newcommand\casename{Przypadek}
  \newcommand\conclusionname{Konkluzja}

  \newcommand\hintname{Wskaz\'owka}
}

\newcommand*{\ltor}{\mbox{$\Rightarrow\colon$}}
\newcommand*{\rtol}{\mbox{$\Leftarrow\colon$}}
\newcommand*{\lincr}{\mbox{$\subseteq\colon$}}
\newcommand*{\rincl}{\mbox{$\supseteq\colon$}}

\renewenvironment{proof}[1][\proofname]{\par
  \normalfont
  \topsep6\p@\@plus6\p@ \trivlist
  \item[\hskip\labelsep\scshape
    #1\@addpunct{.}]\ignorespaces
}{%
  \qed\endtrivlist
}

\newenvironment{hint}[1][\hintname]{\par
  \normalfont
  \topsep6\p@\@plus6\p@ \trivlist
  \item[\hskip\labelsep\indent\scshape
    #1\@addpunct{.}]\ignorespaces
}{%
  \endtrivlist
}

\newcount\@conddepth \@conddepth = 0
\@definecounter{condition}
\def\thecondition{\@arabic\c@condition}
\def\labelcondition{\upshape(\thecondition)}

\newenvironment{conditions}{%
    \ifnum \@conddepth >0 \@toodeep\else
      \advance\@conddepth\@ne
        \list{\labelcondition}
          {\usecounter{condition}\def\makelabel##1{\hss\llap{##1}}
            \topsep3\p@\leftmargin50\p@\labelsep8\p@}%
    \fi
  }{%
    \endlist}

\newcount\@sentdepth \@sentdepth = 0
\@definecounter{sentence}
\def\thesentence{\@roman\c@sentence}
\def\labelsentence{\upshape(\thesentence)}

\newenvironment{sentences}{%
    \ifnum \@sentdepth >0 \@toodeep\else
      \advance\@sentdepth\@ne
        \list{\labelsentence}
          {\usecounter{sentence}\def\makelabel##1{\hss\llap{##1}}
            \topsep3\p@\leftmargin0\p@\itemindent40\p@\labelsep8\p@}%
    \fi
  }{%
    \endlist}

\def\mathstyle#1{%
  \@ifundefined{ms@#1}{%
    \PackageWarning{Math}{Unknown mathstyle `#1'}%
    \gdef\m@thstyle{plain}
    \ms@plain
  }{%
    \gdef\m@thstyle{#1}
    \@nameuse{ms@#1}}}
\@onlypreamble\mathstyle

\def\ms@plain{%
  \def\th@plaintheorem{%
    \th@plain}
  \def\th@plaindefinition{%
    \th@definition}
  \def\th@plainremark{%
    \th@remark}} 

\def\ms@heads{%
  \def\th@headstheorem{%
    \th@plain
    \thm@headfont{\bfseries}}
  \def\th@headsdefinition{%
    \th@definition
    \thm@headfont{\bfseries}}
  \def\th@headsremark{%
    \th@remark
    \thm@headfont{\bfseries}}}
  
\def\ms@simple{%
  \def\th@simpletheorem{%
    \th@plain
    \normalfont
    \thm@headfont{\bfseries}}
  \def\th@simpledefinition{%
    \th@definition
    \thm@headfont{\bfseries}}
  \def\th@simpleremark{%
    \th@remark
    \thm@headfont{\bfseries\itshape}}}

\mathstyle{heads}

\def\settheoremstyle{\theoremstyle{\m@thstyle theorem}}
\def\setdefinitionstyle{\theoremstyle{\m@thstyle definition}}
\def\setremarkstyle{\theoremstyle{\m@thstyle remark}}

\def\thmsupcounter#1{%
   \gdef\@thmsupcounter{#1}}

\let\@thmsupcounter\@empty

\AtBeginDocument{%
  \settheoremstyle
  \ifx\@thmsupcounter\@empty
    \let\@notdefinable@org\@notdefinable
    \let\@notdefinable\relax
    \def\@newprithm{\newtheorem{thm}{\theoremname}[chapter]}
    \@ifdefinable\c@chapter{%
      \gdef\@newprithm{\newtheorem{thm}{\theoremname}[section]}}
    \@ifdefinable\c@section{%
      \gdef\@newprithm{\newtheorem{thm}{\theoremname}}}
    \let\@notdefinable\@notdefinable@org
    \@newprithm 
    \let\@newprithm\@empty     
  \else
    \newtheorem{thm}{\theoremname}[\@thmsupcounter]
  \fi
  \newtheorem{lem}[thm]{\lemmaname}
  \newtheorem{cor}[thm]{\corollaryname}
  \newtheorem{prop}[thm]{\propositionname}
  \newtheorem{conj}[thm]{\conjecturename}
  \newtheorem{crit}[thm]{\criterionname}
  \newtheorem{alg}[thm]{\algorithmname}
  \newtheorem{fact}[thm]{\factname}
  \newtheorem{hypo}[thm]{\hypothesisname}

  \newtheorem*{thm*}{\theoremname}
  \newtheorem*{lem*}{\lemmaname}
  \newtheorem*{cor*}{\corollaryname}
  \newtheorem*{prop*}{\propositionname}
  \newtheorem*{conj*}{\conjecturename}
  \newtheorem*{crit*}{\criterionname}
  \newtheorem*{alg*}{\algorithmname}
  \newtheorem*{fact*}{\factname}
  \newtheorem*{hypo*}{\hypothesisname}

  \setdefinitionstyle
  \newtheorem{dfn}[thm]{\definitionname}
  \newtheorem{cond}[thm]{\conditionname}
  \newtheorem{prob}[thm]{\problemname}
  \newtheorem{exm}[thm]{\examplename}
  \newtheorem{exr}[thm]{\exercisename}

  \newtheorem*{dfn*}{\definitionname}
  \newtheorem*{cond*}{\conditionname}
  \newtheorem*{prob*}{\problemname}
  \newtheorem*{exm*}{\examplename}
  \newtheorem*{exr*}{\exercisename}

  \setremarkstyle
  \newtheorem*{rem}{\remarkname}
  \newtheorem*{note}{\notename}
  \newtheorem*{nota}{\notationname}
  \newtheorem*{clm}{\claimname}
  \newtheorem*{summ}{\summaryname}
  \newtheorem*{ack}{\acknowledgmentname}
  \newtheorem*{case}{\casename}
  \newtheorem*{conc}{\conclusionname}}

\newcommand*{\math@err}{\PackageError{Math}}
    
%%%% end of 



%%%% polext.sty

\DeclareFontShape{\encodingdefault}{cmr}{bx}{sc}
      {
      <-10> sub* cmr/bx/sc
      <10> <10.95> <12> <14.4> <17.28> <20.74> <24.88> plbxsc10
      }{}

\def\OrgNew@Command#1{
  \let\@ifdefinable\@rc@ifdefinable
  \new@command#1}

\def\RenewCommand#1{%
  {\escapechar\m@ne\xdef\@gtempa{{\string#1}}}%
  \expandafter\@ifundefined\@gtempa
     {\let\New@Command\@gobbletwo}%
     {\let\New@Command\OrgNew@Command}%
  \New@Command#1
}

\RenewCommand\headtoname{}

\RenewCommand\proofname{Dow\'od}
\RenewCommand\indexnoname{Nr albumu}
\RenewCommand\dateending{\space r.}

%%%% end of polext.sty


\if@hyperref
  \RequirePackage{hyperref}[2003/11/30 v6.74m]
\fi

\if@showmarginals
  \RequirePackage{showlabels}[2016/06/09 v1.8]
  \renewcommand{\showlabelfont}{\normalfont\ttfamily\tiny}
\fi

\if@showproofs%
\else
  \hideproofs
\fi


%%%% imuwbth.cls proper settings

\if@final
  \pagestyle{headings}
  \def\oddhead{\hbox to\textwidth{\reset@font\scshape\@brieftitle\hfil\thepage}}
  \let\evenhead\oddhead
\else
  \pagestyle{headandfoot}
  \def\@xoverrule{\@overrule}  
\fi
 
\renewcommand\undersupervision{%
  \slshape Praca \@thesiskind\ napisana\\
  \slshape pod kierunkiem\\
  \upshape \@supervisor}%

\university{Uniwersytet w Bia{\l}ymstoku}
\faculty{Wydzia{\l} Matematyki}
\institute{\relax}
\def\thesisyear#1{\gdef\@thesisyear{#1}}
\def\@thesisyear{\number\year}
\placeandyear{Bia{\l}ystok \@thesisyear}

\def\title{\@dblarg\@xtitle}
\def\@xtitle[#1]#2{\gdef\@title{#2}\gdef\@brieftitle{#1}}
\let\@brieftitle\@empty

\endinput
%%
%% End of file `imuwbth.cls'.
